@ECHO OFF
REM ============================================================================
REM # Copyright (C) 2024 Schneider Electric. All Rights Reserved.
REM # Version 1.1 : New Release
REM ============================================================================
PUSHD %~dp0
OPENFILES > NUL 2>&1
IF NOT %ERRORLEVEL% EQU 0 GOTO NOTADMIN

.\bin\DIDO_Config1 /u
IF %ERRORLEVEL% EQU -1 	GOTO END
IF %ERRORLEVEL% EQU 0 	GOTO SETCONFIG
::Slot 1 has H/W with old F/W and Slot 2 is empty | No F/W update required
IF %ERRORLEVEL% EQU 8	GOTO UPDATE1
::Slot 1 has H/W with new F/W and Slot 2 is empty | No F/W update required
IF %ERRORLEVEL% EQU 10	GOTO UPDATE2
::Slot 2 has H/W with old F/W and Slot 1 is empty | No F/W update required
IF %ERRORLEVEL% EQU 4	GOTO UPDATE3
::Slot 2 has H/W with new F/W and Slot 1 is empty | No F/W update required
IF %ERRORLEVEL% EQU 5	GOTO UPDATE4
::Slot 1 and 2 has H/W with old F/W
IF %ERRORLEVEL% EQU 12	GOTO UPDATE5
::Slot 1 has H/W with old F/W and Slot 2 has H/W with new F/W
IF %ERRORLEVEL% EQU 13	GOTO UPDATE6
::Slot 1 has H/W with new F/W and slot 2 has H/W with old F/W 
IF %ERRORLEVEL% EQU 14	GOTO UPDATE7
::Slot 1 and 2 have H/W with new F/W
IF %ERRORLEVEL% EQU 15 	GOTO UPDATE8

:UPDATE1
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND1
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE1

:DRIVERFOUND1
ECHO Driver found.

:UPDATE1
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE2
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND2
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE2

:DRIVERFOUND2
ECHO Driver found.

:UPDATE2
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v2.0.1-R_0927.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE3
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND3
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE3

:DRIVERFOUND3
ECHO Driver found.

:UPDATE3
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE4
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND4
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE4

:DRIVERFOUND4
ECHO Driver found.

:UPDATE4
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v2.0.1-R_0927.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE5
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND5
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE5

:DRIVERFOUND5
ECHO Driver found.

:UPDATE5
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL

TIMEOUT /T 3 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE6
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND6
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE6

:DRIVERFOUND6
ECHO Driver found.

:UPDATE6
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL

TIMEOUT /T 3 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v2.0.1-R_0927.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE7
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND7
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE7

:DRIVERFOUND7
ECHO Driver found.

:UPDATE7
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v2.0.1-R_0927.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL

TIMEOUT /T 3 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE8
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND8
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE8

:DRIVERFOUND8
ECHO Driver found.

:UPDATE8
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v2.0.1-R_0927.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL

TIMEOUT /T 3 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v2.0.1-R_0927.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:SETCONFIG
.\bin\DIDO_Config1 /K
GOTO END

:UPDATEFAIL
ECHO Update failed.
GOTO END

:NOTADMIN
ECHO Please run as administrator.

:END
POPD
PAUSE
